
rem	//HELP: if you are using Notepad++ to view this, you can set the language to VB for your convenience
rem //NOTE: Please see the HiCON Basic Documentation (found on the website) for more detailed information


rem	//This code demonstrates how to manipulate the LEDs in Mach3 with HiCON
rem //The "Get/Set LED" commands, write or retrieve the data of the LEDs in Mach3




1000 
if GetLED(2001) = 1 then goto 2000   :REM Tool Change Function Command - User LED 2001
if GetLED(2002) = 1 then goto 2500   :REM Tool Indexer Function Command  - User LED 2002

goto 5000 :REM no mach3 command detected, goto exit macro


REM //////// this code will turn on output 17 for 1/2 second as part of tool change macro
2000  
SetPin( 11, 8, 1 )  :REM turn on output 17 for tool changer
Sleep(500)
SetHiCON( 40+17, 0 )  :REM turn off output 17 for tool changer
SetLED( 2052, 1 )  :REM turn on User LED 2052 to tell mach3 vb macro that we are done

goto 5000 :REM goto Exit macro


REM ////// this code will turn on output 21 and watch an input as part of tool indexer
2500 
SetHiCON( 40+21, 1 )  :REM turn on output 21 for tool indexer


REM watch digital input on J11 to see if indexer is in position
2510
if GetHiCON(140+10) = 0 then goto 2510 :Rem Wait for input to become active
SetHiCON( 40+21, 0 )  :REM turn off output 21 for tool indexer
SetLED( 2052, 1 )  :REM turn on User LED 2052 to tell mach3 vb macro that we are done

goto 5000 :REM goto Exit macro


REM ========================================================

5000 :REM Exit Macro location
print "Done!!!!!"





