
rem	//HELP: if you are using Notepad++ to view this, you can set the language to VB for your convenience
rem //NOTE: Please see the HiCON Basic Documentation (found on the website) for more detailed information


rem	//This code demonstrates how to use the "DoMotionXYZ()" command with different motion types
rem //The "DoMotionXYZ()" command executes point to point motion for x, y, and z axes from current position.  


rem /////////PARAMETERS://///////////////////////////////
rem //DoMotionXYZ(FLOAT positionX, FLOAT positionY, FLOAT positionZ, FLOAT acceleration, FLOAT velocity, INT mode)
rem //Position is in units, acceleration is in unit/sec2, and velocity is in units/min
rem //Mode: 2 for incremental, 4 for absolute, 8 for velocity move
rem ////////////////////////////////////////////////////////


rem //WARNING: float values without a ".00" specified will error out as the interpreter tags them as integer values

rem //Incremental
DoMotionXYZ(-10.00, 7.50, 4.00, 5.00, 40.00, 2)
PRINT "Moving XYZ Axes by (-10.00, 7.50, 4.00) units"
Sleep(10) 

GOSUB 1000

rem //Absolute
DoMotionXYZ(-1.00, -1.00, -1.00, 5.00, 40.00, 4)
PRINT "Moving XYZ axes to position (-1, -1, -1)"
Sleep(10)

GOSUB 1000



rem //Velocity
rem //NOTE: When using velocity motion, ONLY the sign of the position paramenter is used (as the direction)
DoMotionXYZ(1.00, 1.00, 1.00, 5.00, 40.00, 8)
PRINT "Moving XYZ axes to the positive direction for 5 seconds"
rem //Wait for 5 seconds
Sleep(5000)
rem //Cancel the motion on all axes after waiting
CancelMove(0)
CancelMove(1)
CancelMove(2)

PRINT "Program ended"
Sleep(10)
END

rem //Subroutine to wait for the motion to finish before starting a new motion
1000 b = GetHiCON(120)
PRINT "Waiting for motion to finish..."
WHILE b = 1
b = GetHICON(120)
WEND
RETURN

