
rem	//HELP: if you are using Notepad++ to view this, you can set the language to VB for your convenience
rem //NOTE: Please see the HiCON Basic Documentation (found on the website) for more detailed information


rem	//This code demonstrates how to use the "DoMotionAxis()" command with different motion types
rem //The "DoMotionAxis()" command executes point to point motion for selected axis from current position.


rem /////////PARAMETERS://///////////////////////////////
rem //DoMotionAxis(INT axisID, FLOAT finalPosition, FLOAT acceleration, FLOAT velocity, INT mode )
rem //Position is in units, acceleration is in unit/sec2, and velocity is in units/min
rem //Mode: 2 for incremental, 4 for absolute, 8 for velocity move
rem ////////////////////////////////////////////////////////


rem //WARNING: float values without a ".00" specified will error out as the interpreter tags them as integer values

rem //Absolute
DoMotionAxis(0, 5.00, 5.00, 50.00, 4)
PRINT "Moving xAxis to position 5.00"
Sleep(10)

GOSUB 1000

rem //Incremental
DoMotionAxis(1, -10.00, 5.00, 50.00, 2)
PRINT "Moving yAxis by -10 units"
Sleep(10) 

GOSUB 1000

rem //Velocity
rem //NOTE: When using velocity motion, ONLY the sign of the position paramenter is used (as the direction)
DoMotionAxis(2,  1.00,  5.00, 50.00, 8)
PRINT "Moving zAxis to the positive direction for 5 seconds"
rem //Wait for 5 seconds
Sleep(5000)
rem //Cancel the motion after waiting
CancelMove(2)

PRINT "Program ended"
Sleep(10)
END

rem //Subroutine to wait for the motion to finish before starting a new motion
1000 b = GetHiCON(120)
PRINT "Waiting for motion to finish..."
WHILE b = 1
b = GetHICON(120)
WEND
RETURN

