VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "HiCON Motion API TestApp (VB6)"
   ClientHeight    =   5280
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   6585
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5280
   ScaleWidth      =   6585
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cancelMotionButton 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   2520
      TabIndex        =   16
      Top             =   2880
      Width           =   855
   End
   Begin VB.CommandButton executeMotionButton 
      Caption         =   "Execute"
      Height          =   375
      Left            =   2520
      TabIndex        =   15
      Top             =   2400
      Width           =   855
   End
   Begin VB.TextBox positionTextbox 
      Height          =   315
      Left            =   360
      TabIndex        =   12
      Text            =   "0"
      Top             =   720
      Width           =   1695
   End
   Begin VB.TextBox accelTextbox 
      Height          =   315
      Left            =   360
      TabIndex        =   10
      Text            =   "10"
      Top             =   1920
      Width           =   1695
   End
   Begin VB.TextBox speedTextbox 
      Height          =   315
      Left            =   360
      TabIndex        =   9
      Text            =   "100"
      Top             =   1320
      Width           =   1695
   End
   Begin VB.ComboBox axisCombobox 
      Height          =   315
      ItemData        =   "Form1.frx":0000
      Left            =   360
      List            =   "Form1.frx":000D
      TabIndex        =   6
      Text            =   "X"
      Top             =   2520
      Width           =   615
   End
   Begin VB.CommandButton jogPlusButton 
      Caption         =   ">>"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2760
      TabIndex        =   5
      Top             =   1800
      Width           =   495
   End
   Begin VB.CommandButton jogMinusButton 
      Caption         =   "<<"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2280
      TabIndex        =   4
      Top             =   1800
      Width           =   495
   End
   Begin VB.TextBox zPosTextbox 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4320
      TabIndex        =   3
      Text            =   "0"
      Top             =   1800
      Width           =   1935
   End
   Begin VB.TextBox yPosTextbox 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4320
      TabIndex        =   2
      Text            =   "0"
      Top             =   1320
      Width           =   1935
   End
   Begin VB.TextBox xPosTextbox 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4320
      TabIndex        =   1
      Text            =   "0"
      Top             =   840
      Width           =   1935
   End
   Begin VB.CommandButton armButton 
      Caption         =   "Arm"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   360
      MaskColor       =   &H00FFFFFF&
      Style           =   1  'Graphical
      TabIndex        =   0
      Top             =   3240
      Width           =   1335
   End
   Begin VB.Timer Timer1 
      Interval        =   10
      Left            =   5880
      Top             =   360
   End
   Begin VB.Frame Frame1 
      Caption         =   "Axis Jog"
      Height          =   735
      Left            =   2160
      TabIndex        =   7
      Top             =   1560
      Width           =   1215
   End
   Begin VB.Frame motionFrame 
      Caption         =   "Motion"
      Height          =   3855
      Left            =   120
      TabIndex        =   8
      Top             =   120
      Width           =   3495
      Begin VB.CheckBox homeReverseCheckbox 
         Caption         =   "Check1"
         Height          =   255
         Left            =   960
         TabIndex        =   55
         Top             =   2400
         Width           =   255
      End
      Begin VB.CommandButton homeButton 
         Caption         =   "Home"
         Height          =   375
         Left            =   2400
         TabIndex        =   54
         Top             =   3240
         Width           =   855
      End
      Begin VB.Frame Frame3 
         Caption         =   "Type"
         Height          =   975
         Left            =   2040
         TabIndex        =   18
         Top             =   360
         Width           =   1215
         Begin VB.OptionButton absoluteMotionOption 
            Caption         =   "Absolute"
            Height          =   255
            Left            =   120
            TabIndex        =   20
            Top             =   520
            Width           =   950
         End
         Begin VB.OptionButton relativeMotionOption 
            Caption         =   "Relative"
            Height          =   255
            Left            =   120
            TabIndex        =   19
            Top             =   280
            Width           =   900
         End
      End
      Begin VB.Label Label3 
         Caption         =   "Home Dir Reverse"
         Height          =   495
         Left            =   1200
         TabIndex        =   56
         Top             =   2330
         Width           =   735
      End
      Begin VB.Label Label7 
         Caption         =   "Axis"
         Height          =   255
         Left            =   240
         TabIndex        =   17
         Top             =   2160
         Width           =   495
      End
      Begin VB.Label Label6 
         Caption         =   "Accel (units/sec2)"
         Height          =   255
         Left            =   240
         TabIndex        =   14
         Top             =   1560
         Width           =   1695
      End
      Begin VB.Label Label5 
         Caption         =   "Speed (units/min)"
         Height          =   255
         Left            =   240
         TabIndex        =   13
         Top             =   960
         Width           =   1695
      End
      Begin VB.Label Label4 
         Caption         =   "Position"
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   360
         Width           =   735
      End
   End
   Begin VB.Frame Form1 
      Caption         =   "Status"
      Height          =   3855
      Left            =   3720
      TabIndex        =   21
      Top             =   120
      Width           =   2775
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   15
         Left            =   2160
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   53
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   14
         Left            =   2040
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   52
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   13
         Left            =   1920
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   51
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   12
         Left            =   1800
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   50
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   11
         Left            =   1680
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   49
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   10
         Left            =   1560
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   48
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   9
         Left            =   1440
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   47
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   8
         Left            =   1320
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   46
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalOutputLED 
         Height          =   255
         Index           =   7
         Left            =   1080
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   45
         Top             =   3000
         Width           =   135
      End
      Begin VB.PictureBox digitalOutputLED 
         Height          =   255
         Index           =   6
         Left            =   960
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   44
         Top             =   3000
         Width           =   135
      End
      Begin VB.PictureBox digitalOutputLED 
         Height          =   255
         Index           =   5
         Left            =   840
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   43
         Top             =   3000
         Width           =   135
      End
      Begin VB.PictureBox digitalOutputLED 
         Height          =   255
         Index           =   4
         Left            =   720
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   42
         Top             =   3000
         Width           =   135
      End
      Begin VB.PictureBox digitalOutputLED 
         Height          =   255
         Index           =   3
         Left            =   600
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   41
         Top             =   3000
         Width           =   135
      End
      Begin VB.PictureBox digitalOutputLED 
         Height          =   255
         Index           =   2
         Left            =   480
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   40
         Top             =   3000
         Width           =   135
      End
      Begin VB.PictureBox digitalOutputLED 
         Height          =   255
         Index           =   1
         Left            =   360
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   39
         Top             =   3000
         Width           =   135
      End
      Begin VB.PictureBox digitalOutputLED 
         Height          =   255
         Index           =   0
         Left            =   240
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   38
         Top             =   3000
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   7
         Left            =   1080
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   36
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   6
         Left            =   960
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   35
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   5
         Left            =   840
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   34
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   4
         Left            =   720
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   33
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   3
         Left            =   600
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   32
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   2
         Left            =   480
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   31
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   1
         Left            =   360
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   30
         Top             =   2400
         Width           =   135
      End
      Begin VB.PictureBox digitalInputLED 
         Height          =   255
         Index           =   0
         Left            =   240
         ScaleHeight     =   195
         ScaleWidth      =   75
         TabIndex        =   28
         Top             =   2400
         Width           =   135
      End
      Begin VB.Label Label2 
         Caption         =   "P11 Digital Outputs"
         Height          =   255
         Left            =   240
         TabIndex        =   37
         Top             =   2760
         Width           =   1455
      End
      Begin VB.Label Label1 
         Caption         =   "P11 Digital Inputs"
         Height          =   255
         Left            =   240
         TabIndex        =   29
         Top             =   2160
         Width           =   1335
      End
      Begin VB.Label serialLabel 
         Caption         =   "Serial:"
         Height          =   255
         Left            =   240
         TabIndex        =   27
         Top             =   360
         Width           =   1695
      End
      Begin VB.Label Label10 
         Caption         =   "Z"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   240
         TabIndex        =   24
         Top             =   1680
         Width           =   255
      End
      Begin VB.Label Label9 
         Caption         =   "Y"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   240
         TabIndex        =   23
         Top             =   1200
         Width           =   255
      End
      Begin VB.Label Label8 
         Caption         =   "X"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   13.5
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   240
         TabIndex        =   22
         Top             =   720
         Width           =   255
      End
   End
   Begin VB.Frame Frame5 
      Caption         =   "Log"
      Height          =   1095
      Left            =   120
      TabIndex        =   25
      Top             =   4080
      Width           =   6375
      Begin VB.Label logLabel 
         Height          =   735
         Left            =   240
         TabIndex        =   26
         Top             =   240
         Width           =   5895
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Const xmlConfigPath = "hiconConfig.xml"
Dim xmlConfigLoaded As Boolean

Dim isOnline As Boolean
Dim lastOnline As Boolean
Dim isArmed As Boolean
Dim lastArmed As Boolean
Dim isMoving As Boolean

Dim axisPositions(0 To 5) As Double
Dim axisSelection As Long

Dim currentJogAxis As Long
Dim currentJogDir As Long

Dim currentMoveFlags As Long

Dim inputPinStates(0 To 15) As Boolean
Dim outputPinStates(0 To 7) As Boolean




'Digital Output LEDs can be clicked to force a manual toggle
Private Sub digitalOutputLED_Click(Index As Integer)
    If (outputPinStates(Index)) Then
        vsiCmdSetDigitalOutput 11, Index, False
    Else
         vsiCmdSetDigitalOutput 11, Index, True
    End If
End Sub



'////////////////////////////////////////////////////////////////////////////////////////////
'// FORM LOAD
'////////////////////////////////////////////////////////////////////////////////////////////
Private Sub Form_Load()
    ChDrive App.Path
    ChDir App.Path
    
    isOnline = False
    isArmed = False
    currentJogDir = 0

    axisCombobox.ListIndex = 0
    absoluteMotionOption.value = True
    currentMoveFlags = VSI_MOVE_ABSOLUTE
    
    'Set axes X, Y, Z to arm
    axisSelection = 7
    
    'Open a debugging console to display all notifications from the API
    vsiAPIOpenConsole
    
    'Initialize several stuff in the API
    vsiAPIInitialize
    
    'Load the XML File containing the necessary configuration to download to the Controller
    xmlConfigLoaded = (vsiAPILoadXMLConfig(xmlConfigPath) = VSI_ERROR_NONE)
End Sub





Private Sub homeButton_Click()
    If (axisCombobox.ListIndex >= 0) Then
        vsiCmdExecuteHoming axisCombobox.ListIndex, CDbl(positionTextbox.Text), CDbl(speedTextbox.Text), CDbl(accelTextbox.Text), homeReverseCheckbox.value
    End If
End Sub

'////////////////////////////////////////////////////////////////////////////////////////////
'// UPDATE LOOP
'////////////////////////////////////////////////////////////////////////////////////////////
Private Sub Timer1_Timer()

    'No XML config, means no motion
    If (xmlConfigLoaded = False) Then
        Exit Sub
    End If

    'Check if the Controller is still Online and Armed
    vsiStatusIsOnline isOnline
    vsiStatusIsArmed isArmed

    'Set Drive enable outputs to true
    vsiCmdSetDigitalOutput 11, 0, isArmed
    vsiCmdSetDigitalOutput 11, 1, isArmed
    
    'Disable Execute Motion while motion is in progress for the selected axis
    If isArmed Then
        If (axisCombobox.ListIndex >= 0) Then
            Dim axisMoving As Boolean
            vsiStatusIsMoving axisCombobox.ListIndex, axisMoving

            executeMotionButton.Enabled = (axisMoving = False)
            homeButton.Enabled = (axisMoving = False)
            cancelMotionButton.Enabled = axisMoving
        End If
    End If
    
    'If the controller was disarmed, disable motion, and query the last notification from the API
    If Not (isArmed) And lastArmed Then
        EnableMotion (False)

        Dim errorString As String * 200
        Dim errorLength As Long
    
        vsiAPIGetLastNotification errorString, errorLength
        logLabel.Caption = Trim(errorString)
    End If
    
    
    If (isOnline) Then
        'Perform the data exchange to send all output information and receive all input information
        vsiCmdDataExchange
        
        'Query the current axis positions. The value depends on the type of feedback in the XML config
        For axis = 0 To 5 Step 1
            vsiStatusGetAxisPosition axis, axisPositions(axis)
        Next
        
        xPosTextbox.Text = CStr(axisPositions(0))
        yPosTextbox.Text = CStr(axisPositions(1))
        zPosTextbox.Text = CStr(axisPositions(2))
       
        'Update Digital Inputs Display
        For pin = 0 To 15 Step 1
            vsiStatusGetDigitalInput 11, pin, inputPinStates(pin)
            If (inputPinStates(pin)) Then
                digitalInputLED(pin).BackColor = ColorConstants.vbGreen
            Else
                digitalInputLED(pin).BackColor = ColorConstants.vbRed
            End If
        Next
        
        'Update Digital Outputs Display
        For pin = 0 To 7 Step 1
            vsiStatusGetDigitalOutput 11, pin, outputPinStates(pin)
            If (outputPinStates(pin)) Then
                digitalOutputLED(pin).BackColor = ColorConstants.vbGreen
            Else
                digitalOutputLED(pin).BackColor = ColorConstants.vbRed
            End If
        Next
    Else
        serialLabel.Caption = "Serial: OFFLINE"
        logLabel.Caption = "Controller OFFLINE"
        
        For pin = 0 To 15 Step 1
            digitalInputLED(pin).BackColor = BackColor
        Next
        
        For pin = 0 To 7 Step 1
            digitalOutputLED(pin).BackColor = BackColor
        Next
        
        'This function sends out a broadcast message an all available adapters to search for a HiCON on the network
        'a serial number can be specified to connect to a particular unit if multiple are present on the network
        'a blank serial number indicates that the application will connect to the first HiCON it can find
        'NOTE: always set the poll interval to the same interval at which you call the data exchange (In this case the timer interval)
        If (vsiAPIConnect("", Timer1.Interval, 2000) = VSI_ERROR_NONE) Then
            Dim serial As String * 10
            vsiStatusGetSerial serial
            serialLabel.Caption = "Serial: " + Trim(serial)
            logLabel.Caption = ""
        End If
    End If
    
    lastArmed = isArmed
    lastOnline = isOnline
    
End Sub






Private Sub EnableMotion(value As Boolean)
    executeMotionButton.Enabled = value
    cancelMotionButton.Enabled = value
    homeButton.Enabled = value
    jogPlusButton.Enabled = value
    jogMinusButton.Enabled = value
    
    If (value) Then
        armButton.Caption = "DISARM"
        armButton.BackColor = ColorConstants.vbGreen
        logLabel.Caption = "Controller Armed"
    Else
        armButton.Caption = "ARM"
        armButton.BackColor = ColorConstants.vbRed
    End If
End Sub







Private Sub armButton_Click()
    If (isArmed) Then
        If (vsiCmdDisarm = VSI_ERROR_NONE) Then
            EnableMotion (False)
        End If
    Else
        'The axis Selection parameter is a bitmask corresponding to which axes are to be armed
        'In this case, we want to arm X,Y, and Z (00000111) so we send a value of 7
        If (vsiCmdArm(axisSelection) = VSI_ERROR_NONE) Then
            EnableMotion (True)
        End If
    End If
End Sub



Private Sub jogMinusButton_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If (axisCombobox.ListIndex >= 0) Then
        currentJogDir = -1
        currentJogAxis = axisCombobox.ListIndex
        vsiCmdExecuteMove currentJogAxis, -9999, CDbl(speedTextbox.Text), CDbl(accelTextbox.Text), VSI_MOVE_ABSOLUTE, 90
    End If
End Sub



Private Sub jogPlusButton_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If (axisCombobox.ListIndex >= 0) Then
        currentJogDir = 1
        currentJogAxis = axisCombobox.ListIndex
        vsiCmdExecuteMove currentJogAxis, 9999, CDbl(speedTextbox.Text), CDbl(accelTextbox.Text), VSI_MOVE_ABSOLUTE, 90
    End If
End Sub



Private Sub jogMinusButton_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If (currentJogAxis >= 0) Then
        vsiCmdCancelMove currentJogAxis, False
        currentJogDir = 0
        currentJogAxis = -1
    End If
End Sub



Private Sub jogPlusButton_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If (currentJogAxis >= 0) Then
        vsiCmdCancelMove currentJogAxis, False
        currentJogDir = 0
        currentJogAxis = -1
    End If
End Sub



Private Sub absoluteMotionOption_Click()
    currentMoveFlags = VSI_MOVE_ABSOLUTE
End Sub



Private Sub cancelMotionButton_Click()
    If (axisCombobox.ListIndex >= 0) Then
        vsiCmdCancelMove axisCombobox.ListIndex, False
    End If
End Sub



Private Sub relativeMotionOption_Click()
    currentMoveFlags = VSI_MOVE_RELATIVE
End Sub



Private Sub executeMotionButton_Click()
    If (axisCombobox.ListIndex >= 0) Then
        vsiCmdExecuteMove axisCombobox.ListIndex, CDbl(positionTextbox.Text), CDbl(speedTextbox.Text), CDbl(accelTextbox.Text), currentMoveFlags, 99
    End If
End Sub


