Imports System
Imports System.Collections.Generic
Imports System.Linq
Imports System.Text

Imports System.Threading


Namespace VSI
	Public Class LinearMotionSequence
		Inherits MotionSequence
		Public Sub New(feedrate As Double, acceleration As Double)

			MyBase.New(feedrate, acceleration)
		End Sub

		Protected Overrides Sub MotionProcess()
			Dim axisPositions As Double() = New Double(2) {}

			axisPositions(0) = 2
			axisPositions(1) = 0
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteLinearMove(DirectCast(&H7, HiCONDLL.AxisMask), axisPositions, feedrate, acceleration, HiCONDLL.MoveType.ABSOLUTE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = 2
			axisPositions(1) = 2
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteLinearMove(DirectCast(&H7, HiCONDLL.AxisMask), axisPositions, feedrate, acceleration, HiCONDLL.MoveType.ABSOLUTE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = 0
			axisPositions(1) = 2
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteLinearMove(DirectCast(&H7, HiCONDLL.AxisMask), axisPositions, feedrate, acceleration, HiCONDLL.MoveType.ABSOLUTE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = 0
			axisPositions(1) = 0
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteLinearMove(DirectCast(&H7, HiCONDLL.AxisMask), axisPositions, feedrate, acceleration, HiCONDLL.MoveType.ABSOLUTE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()
            m_complete = True
		End Sub
	End Class


	Public Class ArcMotionSequence
		Inherits MotionSequence
		Public Sub New(feedrate As Double, acceleration As Double)

			MyBase.New(feedrate, acceleration)
		End Sub

		Protected Overrides Sub MotionProcess()
			MyBase.MotionProcess()
			Dim axisPositions As Double() = New Double(2) {}

			axisPositions(0) = 2
			axisPositions(1) = 2
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteLinearMove(DirectCast(&H7, HiCONDLL.AxisMask), axisPositions, feedrate, acceleration, HiCONDLL.MoveType.ABSOLUTE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = -2
			axisPositions(1) = 2
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteArcMoveRadius(2, axisPositions, 2, feedrate, HiCONDLL.CLOCKWISE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = 2
			axisPositions(1) = 2
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteArcMoveRadius(2, axisPositions, 2, feedrate, HiCONDLL.CLOCKWISE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = -2
			axisPositions(1) = 2
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteArcMoveAngle(1, axisPositions, 180, feedrate, HiCONDLL.CLOCKWISE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = 2
			axisPositions(1) = 2
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteArcMoveAngle(1, axisPositions, 180, feedrate, HiCONDLL.CLOCKWISE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = 0
			axisPositions(1) = 4
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteArcMoveCenter(2, axisPositions, -2, 0, feedrate, HiCONDLL.CLOCKWISE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = 0
			axisPositions(1) = 4
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteArcMoveCenter(0, axisPositions, -2, 0, feedrate, HiCONDLL.CLOCKWISE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()

			axisPositions(0) = 2
			axisPositions(1) = 2
			axisPositions(2) = 0
			result = HiCONDLL.vsiCmdExecuteArcMoveCenter(2, axisPositions, 0, -2, feedrate, HiCONDLL.COUNTER_CLOCKWISE)
			If Not MotionSuccess(result) Then
				Return
			End If

			WaitForMotionDone()
            m_complete = True
		End Sub
	End Class


	Public Class MotionSequence
		Protected m_complete As Boolean = False
		Public ReadOnly Property Complete() As Boolean
			Get
				Return m_complete
			End Get
		End Property

		Protected m_errorMessage As String = ""
		Public ReadOnly Property ErrorMessage() As String
			Get
				Return m_errorMessage
			End Get
		End Property

		Protected asyncThread As Thread = Nothing
		Protected result As HiCONDLL.ERROR = HiCONDLL.[ERROR].NONE


		Protected feedrate As Double
		Protected acceleration As Double

		Public Sub New(feedrate As Double, acceleration As Double)
			Me.feedrate = feedrate
			Me.acceleration = acceleration
		End Sub


		Public Sub ExecuteAsync()
            Dim action As New Action(AddressOf MotionProcess)
			action.BeginInvoke(Nothing, Nothing)

		End Sub


		Public Sub Cancel()
			If not (asyncThread  is nothing)  Then
				asyncThread.Abort()
				asyncThread = Nothing
			End If

			HiCONDLL.vsiCmdCancelMove(-1, False)
		End Sub


		Protected Sub WaitForMotionDone()
			While True
				System.Threading.Thread.Sleep(100)
				If Not HiCONDLL.vsiStatusIsMoving(-1) Then
					Exit While
				End If
			End While
		End Sub


		Protected Function MotionSuccess(motionResult As HiCONDLL.ERROR) As Boolean
			Me.result = motionResult
			If motionResult <> HiCONDLL.[ERROR].NONE Then
				HiCONDLL.vsiAPIGetLastNotification(m_errorMessage)
				m_errorMessage = m_errorMessage.Trim()
				HiCONDLL.vsiCmdDisarm()
				m_complete = True
				Return False
			End If

			Return True
		End Function

		Protected Overridable Sub MotionProcess()
			asyncThread = Thread.CurrentThread
		End Sub
	End Class

End Namespace
