
'''///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
' HiCON Motion API Header (C#)
' Copyright Vital Systems Inc. 2014
'''///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Imports System
Imports System.Collections.Generic
Imports System.Linq
Imports System.Text
Imports System.Runtime.InteropServices


Namespace VSI
	Public NotInheritable Class HiCONDLL
		Private Sub New()
		End Sub
		Const DLL_PATH As String = "../../HiCONMotionControlAPI.dll"

		Public Enum [ERROR]
			NONE = 0
			OFFLINE = 1
			DISARMED = 2
			INVALID_PARAMETER = 3
			RESPONSE_ERROR = 4
			NO_RESPONSE = 5
			SESSION_MISMATCH = 6
			CONFIG = 7
			ACTIVATION_MISSING = 8
			MOTION_BUFFER_FULL = 9
		End Enum

		Public Enum MoveType
			RELATIVE = 2
			ABSOLUTE = 4
			VELOCITY = 8
		End Enum

		Public Enum AxisMask
			X = 1
			Y = 2
			Z = 4
			A = 8
			B = 16
			C = 32
			ALL = 255
		End Enum

		Public Const AUTO_POLLING As Boolean = True
		Public Const MANUAL_POLLING As Boolean = False

		Public Const MAX_AXIS As Integer = 6
		Public Const MAX_ENCODERS As Integer = 9
		Public Const MAX_ADC_CHANNELS As Integer = 2
		Public Const MAX_DAC_CHANNELS As Integer = 1
		Public Const MAX_DIG_INPUTS As Integer = 64
		Public Const MAX_DIG_OUTPUTS As Integer = 32
		Public Const MAX_STEP_GEN As Integer = 6
		Public Const MAX_DRO_STATUS As Integer = 10

		Public Const CLOCKWISE As Boolean = True
		Public Const COUNTER_CLOCKWISE As Boolean = False



		''' <summary>
		''' 
		''' </summary>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPIOpenConsole() As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function


		''' <summary>
		''' 
		''' </summary>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPIGetSysVars(pVars As Double()) As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function


		''' <summary>
		''' 
		''' </summary>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPIInitialize() As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function


		''' <summary>
		''' 
		''' </summary>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPIDispose() As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function


		''' <summary>
		''' 
		''' </summary>
		''' <param name="serial"></param>
		''' <param name="statusPollIntervalMS"></param>
		''' <param name="timeoutMS"></param>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPIConnect(serial As String, statusPollIntervalMS As Integer, timeoutMS As Integer, AutoPolling As Boolean) As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function


		''' <summary>
		''' 
		''' </summary>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPIDisconnect() As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function


		''' <summary>
		''' 
		''' </summary>
		''' <param name="version"></param>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPIGetVersion(version As StringBuilder) As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function
		Public Shared Function vsiAPIGetVersion(ByRef version As String) As [ERROR]
			Dim stringBuilder As New StringBuilder(version)
			Dim errorType As [ERROR] = vsiAPIGetVersion(stringBuilder)
			version = stringBuilder.ToString()
			Return errorType
		End Function



		''' <summary>
		''' 
		''' </summary>
		''' <param name="error"></param>
		''' <param name="length"></param>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPIGetLastNotification([error] As StringBuilder, ByRef length As Integer) As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function
		Public Shared Function vsiAPIGetLastNotification(ByRef [error] As String) As [ERROR]
			Dim length As Integer = 0
			Dim stringBuilder As New StringBuilder(512)
			Dim errorType As [ERROR] = vsiAPIGetLastNotification(stringBuilder, length)
			[error] = stringBuilder.ToString()
			length = [error].Length
			Return errorType
		End Function


		''' <summary>
		''' 
		''' </summary>
		''' <param name="filePath"></param>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPILoadXMLConfig(filePath As StringBuilder) As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function
		Public Shared Function vsiAPILoadXMLConfig(filePath As String) As [ERROR]
			Dim temp As New StringBuilder(filePath)
			Return vsiAPILoadXMLConfig(temp)
		End Function


		''' <summary>
		''' 
		''' </summary>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiAPIDownloadConfig() As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function


		''' <summary>
		''' 
		''' </summary>
		''' <param name="axisSelection"></param>
		''' <returns></returns>
		<DllImport(DLL_PATH, CharSet := CharSet.Ansi, CallingConvention := CallingConvention.StdCall)> _
		Public Shared Function vsiCmdArm(axisSelection As UInteger) As <MarshalAs(UnmanagedType.I4)> [ERROR]
		End Function

        'Public Shared Function vsiCmdArm(axisSelection As AxisMask) As [ERROR]
        '    Return vsiCmdArm(axisSelection)
        'End Function

        ''' <summary>
        ''' 
        ''' </summary>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdDisarm() As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdDataExchange() As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdClearAxisPosition(axis As Integer) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdSetAxisPosition(axis As Integer, value As Single) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="encoder"></param>
        ''' <param name="counts"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdSetEncoderCounts(encoder As Integer, counts As Integer) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="channel"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdClearEncoderCounts(channel As Integer) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="channel"></param>
        ''' <param name="volts"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdSetDACOutput(channel As Integer, volts As Double) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="port"></param>
        ''' <param name="pinNumber"></param>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdSetDigitalOutput(port As Integer, pinNumber As Integer, value As Boolean) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <param name="position"></param>
        ''' <param name="speed"></param>
        ''' <param name="accel"></param>
        ''' <param name="moveFlags"></param>
        ''' <param name="seqID"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdExecuteMove(axis As Integer, position As Double, speed As Double, accel As Double, moveFlags As MoveType, seqID As UInteger) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axisMap"></param>
        ''' <param name="positions"></param>
        ''' <param name="velocity"></param>
        ''' <param name="accel"></param>
        ''' <param name="moveFlags"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdExecuteLinearMove(axisMap As AxisMask, positions As Double(), velocity As Double, accel As Double, moveFlags As MoveType) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="rotationAxis"></param>
        ''' <param name="positions"></param>
        ''' <param name="startOffset1"></param>
        ''' <param name="startOffset2"></param>
        ''' <param name="feedrate"></param>
        ''' <param name="clockwise"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdExecuteArcMoveCenter(rotationAxis As Integer, positions As Double(), startOffset1 As Double, startOffset2 As Double, feedrate As Double, clockwise As Boolean) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="rotationAxis"></param>
        ''' <param name="positions"></param>
        ''' <param name="radius"></param>
        ''' <param name="feedrate"></param>
        ''' <param name="clockwise"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdExecuteArcMoveRadius(rotationAxis As Integer, positions As Double(), radius As Double, feedrate As Double, clockwise As Boolean) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="rotationAxis"></param>
        ''' <param name="positions"></param>
        ''' <param name="arcAngle"></param>
        ''' <param name="feedrate"></param>
        ''' <param name="clockwise"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdExecuteArcMoveAngle(rotationAxis As Integer, positions As Double(), arcAngle As Double, feedrate As Double, clockwise As Boolean) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <param name="homePosition"></param>
        ''' <param name="speed"></param>
        ''' <param name="accel"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdExecuteHoming(axis As Integer, homePosition As Double, speed As Double, accel As Double) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <param name="instantStop"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdCancelMove(axis As Integer, instantStop As Boolean) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="bufferedMotion"></param>
        ''' <param name="motionPointCount"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiCmdLoadBufferedMotion(bufferedMotion As Double(,), motionPointCount As Integer) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusIsOnline() As <MarshalAs(UnmanagedType.Bool)> Boolean
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusIsArmed() As <MarshalAs(UnmanagedType.Bool)> Boolean
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis">0,1,2... axis number. or use -1 for all axis</param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusIsMoving(axis As Integer) As <MarshalAs(UnmanagedType.Bool)> Boolean
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <param name="seqID"></param>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusIsMotionSequenceDone(axis As Integer, seqID As UInteger, ByRef value As Boolean) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis">axis id = 0,1,2,...</param>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusIsHomeFound(axis As Integer) As <MarshalAs(UnmanagedType.Bool)> Boolean
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="serial"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetSerial(serial As StringBuilder) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function
        Public Shared Function vsiStatusGetSerial(ByRef serial As String) As [ERROR]
            Dim stringBuilder As New StringBuilder(serial)
            Dim errorType As [ERROR] = vsiStatusGetSerial(stringBuilder)
            serial = stringBuilder.ToString()
            Return errorType
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetFollowError(axis As Integer, ByRef value As Double) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="errorBits"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetFollowErrorBits(ByRef errorBits As UInteger) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <param name="seqID"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetMotionSequenceID(axis As Integer, ByRef seqID As UInteger) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <param name="position"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetAxisPosition(axis As Integer, ByRef position As Double) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="axis"></param>
        ''' <param name="position"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetAxisPositions(positions As Double()) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="channel"></param>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetEncoderCounts(channel As Integer, ByRef value As Integer) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="port"></param>
        ''' <param name="pinNumber"></param>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetDigitalInput(port As Integer, pinNumber As Integer) As <MarshalAs(UnmanagedType.Bool)> Boolean
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="port"></param>
        ''' <param name="pinNumber"></param>
        ''' <param name="value"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetDigitalOutput(port As Integer, pinNumber As Integer) As <MarshalAs(UnmanagedType.Bool)> Boolean
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="currentFillLevel"></param>
        ''' <param name="maxFillLevel"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiStatusGetMotionBufferFillLevel(ByRef currentFillLevel As Integer, ByRef maxFillLevel As Integer) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function


        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="customKey"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Public Shared Function vsiActivationIsCustomKeyPresent(customKey As UInteger) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function








        ''' <summary>
        ''' 
        ''' </summary>
        ''' <param name="pStatus"></param>
        ''' <returns></returns>
        <DllImport(DLL_PATH, CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.StdCall)> _
        Private Shared Function vsiStatusGet(ByRef pStatus As msgMoveStatus) As <MarshalAs(UnmanagedType.I4)> [ERROR]
        End Function
        Public Shared Function vsiStatusGet(ByRef deviceStatus As DeviceStatus) As [ERROR]
            Dim pStatus As New msgMoveStatus()
            Dim [error] As [ERROR] = vsiStatusGet(pStatus)

            deviceStatus = New DeviceStatus(pStatus)
            Return [error]
        End Function


        ''' <summary>
        ''' INTERNAL CLASS. Do not use directly
        ''' </summary>
        <StructLayout(LayoutKind.Sequential)> _
        Public Structure msgMoveStatus
            Private dspMCSign As UInt32
            Private MsgType As UInt32

            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_AXIS)> _
            Public MotionSeqID As Integer()

            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_AXIS)> _
            Public CommandPosition As Integer()

            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_AXIS)> _
            Public ActualPosition As Double()

            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_ADC_CHANNELS)> _
            Public ADCCount As Integer()

            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_ENCODERS)> _
            Public EncoderCounter As Integer()

            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_AXIS)> _
            Public FollowError As Integer()

            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_STEP_GEN)> _
            Public StepGenCntr As Integer()

            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_AXIS)> _
            Public MotorStatusBits As UInt16()

            Public SystemStatusBits As UInt32

            Private ProbePoint As Integer
            Private ProbeAxis As Integer

            Public DigiIn0 As UInt32
            Public DigiIn1 As UInt32

            Public DigiOut As UInt32

            Public SpindleRPM As Single

            Private SessionID As UInt32
            Private FifoVectorLevel As UInt32

            Private CmdFIFOLevel As Integer
            Private CmdFIFOSize As Integer

            Private CmdBfrId As UInt32
            'current cmd pos group number. used to report line# back to host pc software, if needed.
            Private EncoderReadTimeStamp As UInt32
            'used to be PIDLoopCounter
            Private StepGenReadTimeStamp As UInt32
            'used to be ServoLoopPeriod
            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_DRO_STATUS)> _
            Private OutputDROs As Single()

            <MarshalAs(UnmanagedType.ByValArray, SizeConst:=MAX_DRO_STATUS)> _
            Private OutputDROIndices As Byte()
            Private OutputLEDs As UInt32
            'GetUserInputBit
        End Structure


        Public Structure MotorStatus
            Const STATUS_BIT_MOTOR_PFG_ACTIVE As UInteger = &H1
            Const STATUS_BIT_MOTOR_SEQ_ACTIVE As UInteger = &H2
            Const STATUS_BIT_MOTOR_HOMED As UInteger = &H4
            Const STATUS_BIT_MOTOR_MACRO_OVERRIDE As UInteger = &H8
            Const STATUS_BIT_MOTOR_LIMIT_LOW As UInteger = &H100
            Const STATUS_BIT_MOTOR_LIMIT_HIGH As UInteger = &H200
            Const STATUS_BIT_MOTOR_FERR As UInteger = &H400

            Private m_commandPosition As Integer
            Private m_actualPosition As Double
            Private followError As Integer
            Private motorStatusBits As UInt16

            Public ReadOnly Property CommandPosition() As Integer
                Get
                    Return m_commandPosition
                End Get
            End Property

            Public ReadOnly Property ActualPosition() As Double
                Get
                    Return m_commandPosition
                End Get
            End Property

            Public ReadOnly Property FollowingError() As Integer
                Get
                    Return followError
                End Get
            End Property

            Public Sub New(commandPosition As Integer, actualPosition As Double, followError As Integer, motorStatusBits As UInt16)
                Me.m_commandPosition = commandPosition
                Me.m_actualPosition = actualPosition
                Me.followError = followError
                Me.motorStatusBits = motorStatusBits
            End Sub

            Public ReadOnly Property IsMotionActive() As Boolean
                Get
                    Return (motorStatusBits And (STATUS_BIT_MOTOR_PFG_ACTIVE)) <> 0
                End Get
            End Property

            Public ReadOnly Property IsSequenceActive() As Boolean
                Get
                    Return (motorStatusBits And STATUS_BIT_MOTOR_SEQ_ACTIVE) <> 0
                End Get
            End Property

            Public ReadOnly Property IsHomed() As Boolean
                Get
                    Return (motorStatusBits And STATUS_BIT_MOTOR_HOMED) <> 0
                End Get
            End Property
        End Structure


        Public Structure DeviceStatus
            'SYSTEM STATUS BITS
            Const STATUS_BIT_DRIVE_ON As UInteger = &H1
            Const STATUS_BIT_FEED_HOLD As UInteger = &H2
            Const STATUS_BIT_GSEQ_EXECUTING As UInteger = &H4

            Const STATUS_BIT_ERROR_ESTOP As UInteger = &H4000
            Const STATUS_BIT_ERROR_KEYLOCK As UInteger = &H8000

            Const STATUS_BIT_ERROR_FOLLOWING As UInteger = &H400000
            Const STATUS_BIT_ERROR_LINK_TIMEOUT As UInteger = &H800000

            Const STATUS_BIT_ERROR_INDEX_FLAG As UInteger = &H1000000
            Const STATUS_BIT_ERROR_FIFO_OVERFLOW As UInteger = &H2000000
            Const STATUS_BIT_ERROR_PROBING As UInteger = &H4000000
            Const STATUS_BIT_PROBING_DONE As UInteger = &H8000000
            Const STATUS_BIT_ERROR_POS_STREAM_SEQ As UInteger = &H10000000
            Const STATUS_BIT_ERROR_DAC_WATCHDOG As UInteger = &H20000000
            Const STATUS_BIT_ERROR_MOTION_SEQ As UInteger = &H40000000

            Public Motor As MotorStatus()

            Public ADCCount As Integer()
            Public encoderCounter As Integer()
            Public stepGenCntr As Integer()

            Private SystemStatusBits As UInt32

            Private digitalInputs As UInt64

            Private digitalOutputs As UInt32

            Private SpindleRPM As Single


            Public Sub New(statusMessage As msgMoveStatus)
                Motor = New MotorStatus(MAX_AXIS - 1) {}
                Dim axis As Integer = 0
                While axis < MAX_AXIS
                    Motor(axis) = New MotorStatus(statusMessage.CommandPosition(axis), statusMessage.ActualPosition(axis), statusMessage.FollowError(axis), statusMessage.MotorStatusBits(axis))
                    System.Math.Max(System.Threading.Interlocked.Increment(axis), axis - 1)
                End While


                ADCCount = New Integer(MAX_ADC_CHANNELS - 1) {}
                Array.Copy(statusMessage.ADCCount, ADCCount, MAX_AXIS)

                encoderCounter = New Integer(MAX_ENCODERS - 1) {}
                Array.Copy(statusMessage.EncoderCounter, encoderCounter, MAX_ENCODERS)

                stepGenCntr = New Integer(MAX_STEP_GEN - 1) {}
                Array.Copy(statusMessage.StepGenCntr, stepGenCntr, MAX_AXIS)

                SystemStatusBits = statusMessage.SystemStatusBits

                digitalInputs = statusMessage.DigiIn1
                digitalInputs = (digitalInputs << 32)
                digitalInputs = digitalInputs Or statusMessage.DigiIn0

                digitalOutputs = statusMessage.DigiOut

                SpindleRPM = statusMessage.SpindleRPM
            End Sub


            Public Function GetDigitalInputState(port As Integer, pin As Integer) As Boolean
                pin = ((port - 11) * 16) + pin
                Return (digitalInputs And Convert.ToUInt64(1 << pin)) <> 0
            End Function

            Public Function GetDigitalInputState(pin As Integer) As Boolean
                Return (digitalInputs And Convert.ToUInt64(1 << pin)) <> 0
            End Function

            Public Function GetDigitalOutputState(port As Integer, pin As Integer) As Boolean
                pin = ((port - 11) * 8) + pin
                Return (digitalInputs And Convert.ToUInt64(1 << pin)) <> 0
            End Function

            Public Function GetDigitalOutputState(pin As Integer) As Boolean
                Return (digitalOutputs And (1 << pin)) <> 0
            End Function
        End Structure


    End Class
End Namespace
