﻿
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// DSPMC Motion API Header (C#)
// Copyright Vital Systems Inc. 2014
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

public static class DSPMCLib
{
    public const int VSI_ERROR_NONE = 0;
    public const int VSI_ERROR_OFFLINE = 1;
    public const int VSI_ERROR_DISARMED = 2;
    public const int VSI_ERROR_INVALID_PARAMETER = 3;
    public const int VSI_ERROR_RESPONSE = 4;
    public const int VSI_ERROR_NO_RESPONSE = 5;
    public const int VSI_ERROR_SESSION_MISMATCH = 6;
    public const int VSI_ERROR_CONFIG = 7;

    public const int VSI_MOVE_RELATIVE = 2;
    public const int VSI_MOVE_ABSOLUTE = 4;
    public const int VSI_MOVE_VELOCITY = 8;	// Velocity Mode (No End point)

    const string DLL_PATH = @"..\..\DSPMCMotionControlAPI.dll";



    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiAPIOpenConsole();

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiAPIInitialize();

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiAPIDispose();

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiAPIConnect( string serial, int statusPollIntervalMS, int timeoutMS);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiAPIDisconnect();

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiAPIGetVersion([MarshalAs(UnmanagedType.VBByRefStr)] ref string version);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiAPIGetLastNotification([MarshalAs(UnmanagedType.VBByRefStr)] ref string error, ref int length);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiAPILoadXMLConfig(string filePath);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiAPIDownloadConfig();


    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdArm(uint axisSelection);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdDisarm();

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdDataExchange();

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdClearAxisPosition(int axis);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdClearEncoderCounts(int channel);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdSetDACOutput(int channel, double volts);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdSetDigitalOutput(int port, int pinNumber, bool value);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdExecuteMove(int axis, double position, double speed, double accel, int moveFlags, uint seqID);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdExecuteHoming(int axis, double homePosition, double speed, double accel, bool direction);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdCancelMove(int axis, bool instantStop);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiCmdLoadBufferedMotion(double[,] bufferedMotion, int motionPointCount);
 





    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusIsOnline(ref bool value);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusIsArmed(ref bool value);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusIsMoving(int axis, ref bool value);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusIsMotionSequenceDone(int axis, uint seqID, ref bool value);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusIsHomeFound(int axis, ref bool value);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusGetSerial([MarshalAs(UnmanagedType.VBByRefStr)] ref string serial);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusGetFollowError(int axis, ref double value);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusGetFollowErrorBits(ref uint errorBits);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusGetMotionSequenceID(int axis, ref uint seqID);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusGetAxisPosition(int axis, ref double position);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusGetEncoderCounts(int channel, ref int value);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusGetDigitalInput(int port, int pinNumber, ref bool value);

    [DllImport(DLL_PATH, CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
    [return: MarshalAs(UnmanagedType.I4)]
    public static extern int vsiStatusGetDigitalOutput(int port, int pinNumber, ref bool value);

}

