
#include "stdafx.h"
#include "3gScan.h"
#include "conio.h"

#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CDevice3G *pDevList;
bool PrevOnlineState[50];
int gDevOfflineCntr[50];
#define MAX_DEV 43
#define START_NODE_ID 50
/////////////////////////////////////////////////
void Main()
{

	printf( "Init 3G Scanner\n" );
	Init3GScanner();

	printf( "Alloc memory for 50 Devices\n" );
	pDevList = new  CDevice3G[50];

	for( int i = 0; i < MAX_DEV; i++ ) 
	{
		pDevList[i].mDeviceIPAddr.Format( _T("192.168.0.%d"),i+START_NODE_ID );
		pDevList[i].mRxRPI = 10;
		pDevList[i].mTxRPI = 50;
		PrevOnlineState[i] = false;
		gDevOfflineCntr[i] = 0;
		printf( "Adding Device %s in Scan List\n", (LPCTSTR)pDevList[i].mDeviceIPAddr );
	}

	printf( "Scanning Devices.........\n1 = Offline counters\n2 = IO Data\n3 = Rx RPI\nq = Quit\n\n" );

	UINT DisplayCntr = 0;
	int ch;
	while( 1 )
	{
		for( int dev = 0; dev < MAX_DEV; dev++ )
		{
			pDevList[dev].DoIOExchange(); //process I/O messages. must be called atleast once every millisec for every device.

			if( PrevOnlineState[dev] != pDevList[dev].mOnline )
			{
				printf( "\nOnline State Change for IP %s = %d\n", (LPCTSTR)pDevList[dev].mDeviceIPAddr, pDevList[dev].mOnline );
				if( !pDevList[dev].mOnline )
					gDevOfflineCntr[dev]++;
			}

			PrevOnlineState[dev] = pDevList[dev].mOnline;
			pDevList[dev].OutputScanData[0] = (BYTE)(GetTickCount() >> 6);	//write random data to outputs
		}

		if( _kbhit() )
		{
			ch = _getch();

			if( ch == 'q' )
				break;

			if( ch == '1' )
			{
				for( int i = 0; i < 5; i++ )
				{	
					printf( "Dev %d: %5d %5d %5d %5d %5d %5d %5d %5d %5d %5d\n", START_NODE_ID+(i*10), gDevOfflineCntr[0+(i*10)], gDevOfflineCntr[1+(i*10)], gDevOfflineCntr[2+(i*10)], 
					gDevOfflineCntr[3+(i*10)], gDevOfflineCntr[4+(i*10)], gDevOfflineCntr[5+(i*10)], gDevOfflineCntr[6+(i*10)], gDevOfflineCntr[7+(i*10)], gDevOfflineCntr[8+(i*10)], gDevOfflineCntr[9+(i*10)] );
				}
				printf( "\n\n" );
			}

			if( ch == '2' )
			{
				printf( "InputScanData[0]\n" );
				for( int i = 0; i < 5; i++ )
				{	
					printf( "Dev %d: %2X  %2X  %2X  %2X  %2X  %2X  %2X  %2X  %2X  %2X\n", START_NODE_ID+(i*10), 
						pDevList[0+(i*10)].InputScanData[0],
						pDevList[1+(i*10)].InputScanData[0],
						pDevList[2+(i*10)].InputScanData[0],
						pDevList[3+(i*10)].InputScanData[0],
						pDevList[4+(i*10)].InputScanData[0],
						pDevList[5+(i*10)].InputScanData[0],
						pDevList[6+(i*10)].InputScanData[0],
						pDevList[7+(i*10)].InputScanData[0],
						pDevList[8+(i*10)].InputScanData[0],
						pDevList[9+(i*10)].InputScanData[0] );
				}
				printf( "\n\n" );
				printf( "InputScanData[2]\n" );
				for( int i = 0; i < 5; i++ )
				{	
					printf( "Dev %d: %2X  %2X  %2X  %2X  %2X  %2X  %2X  %2X  %2X  %2X\n", START_NODE_ID+(i*10), 
						pDevList[0+(i*10)].InputScanData[2],
						pDevList[1+(i*10)].InputScanData[2],
						pDevList[2+(i*10)].InputScanData[2],
						pDevList[3+(i*10)].InputScanData[2],
						pDevList[4+(i*10)].InputScanData[2],
						pDevList[5+(i*10)].InputScanData[2],
						pDevList[6+(i*10)].InputScanData[2],
						pDevList[7+(i*10)].InputScanData[2],
						pDevList[8+(i*10)].InputScanData[2],
						pDevList[9+(i*10)].InputScanData[2] );
				}
				printf( "\n\n" );
			}
			if( ch == '3' )
			{
				printf( "Actual Rx RPI\n" );
				for( int i = 0; i < 5; i++ )
				{	
					printf( "Dev %d: %5d %5d %5d %5d %5d %5d %5d %5d %5d %5d\n", START_NODE_ID+(i*10), 
						pDevList[0+(i*10)].mActualRxRPI,
						pDevList[1+(i*10)].mActualRxRPI,
						pDevList[2+(i*10)].mActualRxRPI,
						pDevList[3+(i*10)].mActualRxRPI,
						pDevList[4+(i*10)].mActualRxRPI,
						pDevList[5+(i*10)].mActualRxRPI,
						pDevList[6+(i*10)].mActualRxRPI,
						pDevList[7+(i*10)].mActualRxRPI,
						pDevList[8+(i*10)].mActualRxRPI,
						pDevList[9+(i*10)].mActualRxRPI );
				}
				printf( "\n\n" );
			}
		}
//		if( (DisplayCntr++ % 100) == 0 )
//			printf( "\rINPUTS 24: %2X, 25: %2X, 26: %2X, Cntr %5d\r",  pDevList[0].InputScanData[0], pDevList[1].InputScanData[0], pDevList[2].InputScanData[0], DisplayCntr >> 4 );

		Sleep(1);
	}

	delete [] pDevList;
}


// The one and only application object
CWinApp theApp;

using namespace std;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		nRetCode = 1;
	}
	else
	{
		Main();
	}

	return nRetCode;
}
