#pragma once
#include "3Gmsg.h"
///////////////////////////////////////////////////
class CDevice3G
{
public:

	CDevice3G()
	{ 
		mTxTimer = mRxTimer = 0; mOnline = false; 
		mSock.Create( 0, SOCK_DGRAM, FD_READ | FD_WRITE, 0 );
		OutputScanData[0] = 0;
		OutputScanData[1] = 0;
		OutputScanData[2] = 0;
		OutputScanData[3] = 0;

		InputScanData[0] = 0;
		InputScanData[1] = 0;
		InputScanData[2] = 0;
		InputScanData[3] = 0;
		InputScanCW1_2[0] = InputScanCW1_2[1] = 0;
		mLastRxTime = -1;
		mActualRxRPI = 0;
	}

	~CDevice3G()
	{
		mSock.Close();
	}

	CString mDeviceIPAddr;
	DWORD mRxRPI; //millisec between rx poll
	DWORD mTxRPI; //millisec between tx poll

	BYTE	InputScanData[4];  //recevie from 3G card. Byte 0 = Inputs, Byte 1 = Output Enable Bit, Byte 2 = Outputs,  
	WORD	InputScanCW1_2[2]; //recevie from 3G card. Ladder Control Word 1 and 2

	BYTE	OutputScanData[4]; 	//send to 3G card.   Byte 0 maps to Digital Outputs if VirtualIO is on.  
								//Byte 0..3 maps to Ladder Control Word 9 and 10 if VirtualIO is off

	bool mOnline;
	DWORD mActualRxRPI;

	void DoIOExchange();	//must be called atleast once every millisec

private:
	DWORD mTxTimer;
	DWORD mRxTimer;
	CAsyncSocket mSock;
	struct SMART3G_IOCmdMsg Smart3GCmd;
	DWORD mLastRxTime;
};

void Init3GScanner();