
#include "stdafx.h"
#include "3gScan.h"

/////////////////////////////////////////////////
void CDevice3G::DoIOExchange()
{
	struct _3GiodataRx RxBfr;
	CString szSrcIP;
	UINT SrcPort;

	//Device IP address not initialized yet
	if( mDeviceIPAddr.GetLength() == 0 )
		return;

	//empty message buffer
	while( mSock.ReceiveFrom( &RxBfr, sizeof(RxBfr), szSrcIP, SrcPort ) > 0 )
	{
		if( RxBfr.MsgSign == 0x80020002 && szSrcIP == mDeviceIPAddr )
		{
			InputScanData[0] = RxBfr.RxIOdata[0];
			InputScanData[1] = RxBfr.RxIOdata[1];
			InputScanData[2] = RxBfr.RxIOdata[2];
			InputScanData[3] = RxBfr.RxIOdata[3];

			InputScanCW1_2[0] = RxBfr.CW1_2[0];
			InputScanCW1_2[1] = RxBfr.CW1_2[1];

			mRxTimer = GetTickCount() + (mRxRPI * 32);	//calc Rx timeout
			if( !mOnline )
				mTxTimer = 0;

			mOnline = true;

			if( mLastRxTime != -1 )
				mActualRxRPI = GetTickCount() - mLastRxTime;

			mLastRxTime = GetTickCount();
		}
	}

	if( mOnline )
	{
		if( GetTickCount() > mTxTimer )	//time to transmit
		{
			struct _3GiodataTx TxBfr;
			TxBfr.TxOutdata[0] = OutputScanData[0];
			TxBfr.TxOutdata[1] = OutputScanData[1];
			TxBfr.TxOutdata[2] = OutputScanData[2];
			TxBfr.TxOutdata[3] = OutputScanData[3];

			mSock.SendTo( &TxBfr, sizeof(TxBfr), 2222, mDeviceIPAddr, MSG_DONTROUTE );

			mTxTimer = GetTickCount() + mTxRPI; //calc time for next transmission
		}

		if( GetTickCount() > mRxTimer ) //timed out waiting for Rx data from Device
		{
			//no response from device.  mark offline
			mOnline = false;
			mTxTimer = 0;
			mLastRxTime = -1;
			//clear input scan memory
			ZeroMemory( InputScanData, sizeof(InputScanData) );
			InputScanCW1_2[0] = 0;
			InputScanCW1_2[1] = 0;
		}
	}
	else //Device is offline
	{
		if( GetTickCount() > mTxTimer )	//time to transmit connect cmd
		{
			ZeroMemory( &Smart3GCmd, sizeof Smart3GCmd );

			Smart3GCmd.iCmd			= 0x004C006F;
			Smart3GCmd.iCmdZ		= 2;
			Smart3GCmd.iCmdU		= 0x003C00B2;
			Smart3GCmd.Cmdx1		= 0x06200254;
			Smart3GCmd.Cmdx2		= 0x0124;
			Smart3GCmd.vid			= 0x380;
			Smart3GCmd.Host_RPI		= mTxRPI * 1000;	//100msec
			Smart3GCmd.Smart3G_RPI	= mRxRPI * 1000;

			mSock.SendTo( &Smart3GCmd, sizeof(Smart3GCmd), 44818, mDeviceIPAddr, MSG_DONTROUTE );
			mTxTimer = GetTickCount() + 350; //calc time for re-transmission
		}
	}
}

/////////////////////////////////////////////////
void Init3GScanner()
{
	AfxSocketInit();
	SetPriorityClass( ::GetCurrentProcess(), HIGH_PRIORITY_CLASS );
}

