        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        struct LDRMsgENet
        {
            UInt16 LdrMsgSign;    // 0xDABA 				       
            UInt16 Len;      	  // Ldr Msg Size 				
            UInt32 SessionID;     // Session identifier 0x9A8A7B6B  

            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
            public byte[] LdrData;

        }
		
MSG -------------
				MsgDt[ 0 ] = gControlWords[DEST_NODE_CWORD]; //destination mac
				MsgDt[ 1 ] = DNT_USER_MSG_CMD; //67
				MsgDt[ 2 ] = gControlWords[ SEND_BFR_CWORD + 0 ];
				MsgDt[ 3 ] = gControlWords[ SEND_BFR_CWORD + 1 ];
				MsgDt[ 4 ] = gControlWords[ SEND_BFR_CWORD + 2 ];
				MsgDt[ 5 ] = gControlWords[ SEND_BFR_CWORD + 3 ];
				MsgDt[ 6 ] = gControlWords[ SEND_BFR_CWORD + 4 ];
				MsgDt[ 7 ] = gControlWords[ SEND_BFR_CWORD + 5 ];
				
				eIPTxLdrMsg( MsgDt, 8, MsgDt[0], 44818 );
---------------

Barcode ---------------------
		if( sData >= ' ' && sData <= 127 )
		{
			SerialBuff[ 2 + SerialIndex++ ] = sData;

			if( SerialIndex >= 6 )
			{
				// time to send the buffer
				SerialBuff[0] = gCfg.HostID;
				SerialBuff[1] = DNT_BARCODE_UNTERM; //65
				eIPTxLdrMsg( SerialBuff, 8, SerialBuff[0], 44818 );
				SerialIndex = 0;
			}
		}
		else if( sData == 0xA || sData == 0xD )
		{
			// time to send the buffer
			SerialBuff[0] = gCfg.HostID;
			SerialBuff[1] = DNT_BARCODE_TERM;  //66
			eIPTxLdrMsg( SerialBuff, SerialIndex + 2, SerialBuff[0], 44818 );
			SerialIndex = 0;
		}
-----------------------

typedef struct LdrMsg_
{
    UINT16 LdrMsgSign;    /* 0xDABA 				        */
    UINT16 Len;      	  /* Ldr Msg Size 					*/
    UINT32 SessionID;     /* Session identifier 0x9A8A7B6B   */
    BYTE   LdrData[8];
} GNU_PACKED  LDRMsgENet;				



void eIPTxLdrMsg( BYTE* MsgDat, int MsgSz, BYTE DestMac, short DestPort )
{
static LDRMsgENet LdrMsg;
static struct sockaddr_in Addr;

	if( MsgSz > 8 )
		return;

	LdrMsg.LdrMsgSign 	= 0xDABA;
	LdrMsg.Len 			= MsgSz;
	LdrMsg.SessionID 	= 0x9A8A7B6B;

	int temp;
	for( temp = 0; temp < MsgSz; temp++ )
		LdrMsg.LdrData[temp] = MsgDat[temp];

	IP_ADDR DestIP;
	
	DestIP.Val = SysIPAddr.Val;
	DestIP.v[3] = DestMac;

	Addr.sin_port = DestPort;
	Addr.sin_addr.S_un.S_addr = DestIP.Val;

	temp = sendto( eIPudpServerSock,
		(char*)&LdrMsg,
		sizeof(LdrMsg),
		0,
		(SOCKADDR *) &Addr,
		sizeof(Addr));	
}
		