﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Smart3GComms;

namespace _3G_CSharp
{

    public partial class Form1 : Form
    {
        Smart3GPoller Device55;
        Smart3GPoller Device60;
        Smart3GMsgPort DeviceMsgs;
        
        public Form1()
        {
            InitializeComponent();

            try
            {
                //instantiate the polling class for each Smart3G
                Device55 = new Smart3GPoller("192.168.0.105", 55, 20, 20, 4);
                Device60 = new Smart3GPoller("192.168.0.105", 60, 20, 20, 4);

                //instantiate the one and only Msg Port class to handle async msgs like barcode reads and ladder logic message
                DeviceMsgs = new Smart3GMsgPort("192.168.0.105");
                timer1.Enabled = true;
            }
            catch
            {
                MessageBox.Show("Network Error.  Make sure Local IP address is correct when instantiating Samrt3G classes", "Samrt3G PC Demo");
                return;
            }
        }

        // Timer: 1 millisec resolution
        private void timer1_Tick(object sender, EventArgs e)
        {
			//execute Smart3G protocol for each device
            Device55.DoIOExchange();
            Device60.DoIOExchange();
            DeviceMsgs.DoIOExchange();
			
			//update online status for each device
            LED_Online55.BackColor = Device55.mDeviceOnline ? Color.Green : Color.Red;
            LED_Online60.BackColor = Device60.mDeviceOnline ? Color.Green : Color.Red;

            //update input status
            LED_Input8.Text = Device55.ReadInputPin(8) ? "1" : "0";
            LED_Input7.Text = Device55.ReadInputPin(7) ? "1" : "0";
            LED_Input6.Text = Device55.ReadInputPin(6) ? "1" : "0";
            LED_Input5.Text = Device55.ReadInputPin(5) ? "1" : "0";
            LED_Input4.Text = Device55.ReadInputPin(4) ? "1" : "0";
            LED_Input3.Text = Device55.ReadInputPin(3) ? "1" : "0";
            LED_Input2.Text = Device55.ReadInputPin(2) ? "1" : "0";
            LED_Input1.Text = Device55.ReadInputPin(1) ? "1" : "0";

            lblInputs60.Text = Device60.ReadInputs().ToString();
            lbCW1.Text = Device60.mCW2.ToString();

			// example: receive barcode from Device 55 and send a response to devices 55 and 60.
            String barcode = "";
			if (DeviceMsgs.GetRcvSerialData(55, ref barcode))
            {
                Barcode55.Text = barcode;

                byte[] cwDat = new byte[6];

                cwDat[0] = 100;  //Ok2Release
                cwDat[1] = Convert.ToByte(barcode[0]);
                cwDat[2] = Convert.ToByte(barcode[1]);
                cwDat[3] = Convert.ToByte(barcode[2]);
                cwDat[4] = Convert.ToByte(barcode[3]);
                cwDat[5] = Convert.ToByte(barcode[4]);
				
                DeviceMsgs.SendExplicitMsg(Device55.NodeID, cwDat);
                DeviceMsgs.SendExplicitMsg(Device60.NodeID, cwDat);
            }
        }

        private void Set55_Output3_Click(object sender, EventArgs e)
        {
            Device55.WriteOutputPin(true, 3);
        }

        private void Clear55_Output3_Click(object sender, EventArgs e)
        {
            Device55.WriteOutputPin(false, 3);
        }

        private void Set60_Output3_Click(object sender, EventArgs e)
        {
            //Device60.WriteOutputPin(true, 3);
            Device60.WriteCW10(4);
        }

        private void Clear60_Output3_Click(object sender, EventArgs e)
        {
            //Device60.WriteOutputPin(false, 3);
            Device60.WriteCW10(0);
        }
    }
}

